//===================================================================================
// NanoKey, or at least a dummy for one.
//===================================================================================
class MSCNanoKey2 extends DeusExPickup;

#exec TEXTURE IMPORT NAME=Level2NanokeyIcon FILE=Textures\Level2NanokeyIcon.PCX GROUP=Icons FLAGS=2 //Belt

var float LoneTime;

function Tick(float DT)
{
 Super.Tick(DT);
 
 if (Owner == None)
 {
  LoneTime += DT;
  
  if (LoneTime > 15)
  {
   Destroy();
  }
 }
}

simulated function bool TestMPBeltSpot(int BeltSpot)
{
   return (BeltSpot >= 0);
}

function inventory SpawnCopy( pawn Other )
{
	local inventory Copy;

	Copy = Super.SpawnCopy(Other);
	Copy.bTossedOut = False;
	MSCNanoKey2(Copy).LoneTime = 0;

	return Copy;
}

function DropFrom(vector StartLocation)
{

   if (Level.Netmode != NM_Standalone)
      bTossedOut = true;
	Super.DropFrom(StartLocation);
}

function BecomePickup()
{
	Super.BecomePickup();

   if (Level.NetMode != NM_Standalone)
      if (bTossedOut)
         Lifespan = 15.0;
}

defaultproperties
{
     ItemArticle="a"
     ItemName="Level 2 NanoKey"
     PlayerViewOffset=(X=30.000000,Z=-12.000000)
     PlayerViewMesh=LodMesh'DeusExItems.NanoKey'
     PickupViewMesh=LodMesh'DeusExItems.NanoKey'
     ThirdPersonMesh=LodMesh'DeusExItems.NanoKey'
     Icon=Texture'MarkistanCity.Level2NanokeyIcon'
     Description="It's a nanokey, it opens shit, kfhx."
     beltDescription="NANO2"
     Mesh=LodMesh'DeusExItems.NanoKey'
     Multiskins(0)=Texture'NanoKeyTex2'
     Multiskins(1)=Texture'GreenLaserSpot'
     CollisionRadius=2.050000
     CollisionHeight=3.110000
     Mass=1.000000
     MaxCopies=1
}
